#include "led.h"
#include "delay.h"
#include "sys.h" 
#include "Display_EPD_W21_spi.h"
#include "Display_EPD_W21.h"
#include "Ap_29demo.h"	
 
//EPD
void EPD_init(void);
void pic_display(void);
void pic_display_white(void);
void EPD_sleep(void);
void EPD_refresh(void);
void lcd_chkstatus_M1(void);
void lcd_chkstatus_S1(void);
void lcd_chkstatus_M2(void);
void lcd_chkstatus_S2(void);
void driver_delay_us(unsigned int xus)  //1us
{
	for(;xus>1;xus--);
}

void driver_delay_xms(unsigned long xms) //1ms
{	
    unsigned long i = 0 , j=0;

    for(j=0;j<xms;j++)
	{
        for(i=0; i<256; i++);
    }
}

 	
void delay_s(xs) //1s
{
	while(xs--)
	delay_ms(1000);
}

//Tips//
/*When the electronic paper is refreshed in full screen, the picture flicker is a normal phenomenon, and the main function is to clear the display afterimage in the previous picture.
  When the local refresh is performed, the screen does not flash.*/
/*When you need to transplant the driver, you only need to change the corresponding IO. The BUSY pin is the input mode and the others are the output mode. */

int main(void)
 {
	delay_init();	    	 //Delay function initialization
	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2); //Set NVIC interrupt grouping
 	LED_Init();			     //LED initialization
  GPIO_1248_Configuration(); //12.48 inch IO port initialization

while(1)
{	
	//picture1
	EPD_init(); //EPD init		
	pic_display();//picture1
	EPD_refresh();//EPD refresh
	EPD_sleep();//EPD_sleep,Sleep instruction is necessary, please do not delete!!!
  delay_s(5);	
	
	//all white
	EPD_init(); //EPD init		
	pic_display_white();//picture  white
	EPD_refresh();//EPD refresh
	delay_s(5);	
	EPD_sleep();//EPD_sleep,Sleep instruction is necessary, please do not delete!!!
	while(1);	
 }
}

 
////////////////////////////////////////////////////////////////////
void EPD_init(void)
{
	unsigned char temp;
	EPD_W21_Init();	//Electronic paper IC reset	
	
	EPD_W21_WriteCMD_M1(0x00);			//panel setting
	EPD_W21_WriteDATA_M1(0x1f);		//KW-3f   KWR-2F	BWROTP 0f	BWOTP 1f
	EPD_W21_WriteCMD_S1(0x00);			//panel setting
	EPD_W21_WriteDATA_S1(0x1f);		//KW-3f   KWR-2F	BWROTP 0f	BWOTP 1f
	//M2S2 turn  180
	EPD_W21_WriteCMD_M2(0x00);			//panel setting
	EPD_W21_WriteDATA_M2(0x13);		//KW-3f   KWR-2F	BWROTP 0f	BWOTP 1f
	EPD_W21_WriteCMD_S2(0x00);			//panel setting
	EPD_W21_WriteDATA_S2(0x13);		//KW-3f   KWR-2F	BWROTP 0f	BWOTP 1f
	
	EPD_W21_WriteCMD_M1(0x06);         //booster soft start
	EPD_W21_WriteDATA_M1 (0x17);		//A
	EPD_W21_WriteDATA_M1 (0x17);		//B
	EPD_W21_WriteDATA_M1 (0x39);		//C
	EPD_W21_WriteDATA_M1 (0x17);
	EPD_W21_WriteCMD_M2(0x06);         //booster soft start
	EPD_W21_WriteDATA_M2 (0x17);		//A
	EPD_W21_WriteDATA_M2 (0x17);		//B
	EPD_W21_WriteDATA_M2 (0x39);		//C
	EPD_W21_WriteDATA_M2 (0x17);

	EPD_W21_WriteCMD_M1(0x61);			//resolution setting
	EPD_W21_WriteDATA_M1 (0x02);
	EPD_W21_WriteDATA_M1 (0x88);       //source 648
	EPD_W21_WriteDATA_M1 (0x01);		//gate 492
	EPD_W21_WriteDATA_M1 (0xEC);
	EPD_W21_WriteCMD_S1(0x61);			//resolution setting
	EPD_W21_WriteDATA_S1 (0x02);
	EPD_W21_WriteDATA_S1 (0x90);       //source 656
	EPD_W21_WriteDATA_S1 (0x01);		//gate 492
	EPD_W21_WriteDATA_S1 (0xEC);
	EPD_W21_WriteCMD_M2(0x61);			//resolution setting
	EPD_W21_WriteDATA_M2 (0x02);
	EPD_W21_WriteDATA_M2 (0x90);       //source 656
	EPD_W21_WriteDATA_M2 (0x01);		//gate 492
	EPD_W21_WriteDATA_M2 (0xEC);
	EPD_W21_WriteCMD_S2(0x61);			//resolution setting
	EPD_W21_WriteDATA_S2 (0x02);
	EPD_W21_WriteDATA_S2 (0x88);       //source 648
	EPD_W21_WriteDATA_S2 (0x01);		//gate 492
	EPD_W21_WriteDATA_S2 (0xEC);


	EPD_W21_WriteCMD_ALL(0x15);			//DUSPI
	EPD_W21_WriteDATA_ALL(0x20);		

	EPD_W21_WriteCMD_ALL(0x50);			//Vcom and data interval setting
	EPD_W21_WriteDATA_ALL(0x21);	//Border KW
	EPD_W21_WriteDATA_ALL(0x07);


	EPD_W21_WriteCMD_ALL(0x60);//TCON
	EPD_W21_WriteDATA_ALL(0x22);

	EPD_W21_WriteCMD_ALL(0xE3);
	EPD_W21_WriteDATA_ALL(0x00);
	
	
	//temperature
	EPD_W21_WriteCMD_M1(0x40);
	lcd_chkstatus_M1();//waiting for the electronic paper IC to release the idle signal
	driver_delay_xms(300);
	temp=EPD_W21_ReadDATA_M1_temp();
	
	EPD_W21_WriteCMD_ALL(0xe0);//Cascade setting
	EPD_W21_WriteDATA_ALL(0x03);
	EPD_W21_WriteCMD_ALL(0xe5);//Force temperature
  EPD_W21_WriteDATA_ALL(temp);
}
void EPD_refresh(void)
{
	EPD_W21_WriteCMD_M1M2(0x04);
  delay_ms(300);
	EPD_W21_WriteCMD_ALL(0x12);			//DISPLAY REFRESH
	lcd_chkstatus_M1(); //waiting for the electronic paper IC to release the idle signal
	lcd_chkstatus_S1(); //waiting for the electronic paper IC to release the idle signal
	lcd_chkstatus_M2(); //waiting for the electronic paper IC to release the idle signal
	lcd_chkstatus_S2(); //waiting for the electronic paper IC to release the idle signal
}
	//////////Enter sleep//////////////////////////////
void EPD_sleep(void)
{
	EPD_W21_WriteCMD_ALL(0X02);  	//power off
	delay_ms(300);

	EPD_W21_WriteCMD_ALL(0X07);  	//deep sleep
	EPD_W21_WriteDATA_ALL(0xA5);
	delay_s(1);
}

//picture//
void pic_display(void)
{
	unsigned int column,row;
		////////M1 part//////////648*492
		EPD_W21_WriteCMD_M1(0x10);
		for(column=492;column<984;column++)
		 for(row=0;row<81;row++)
		{
		EPD_W21_WriteDATA_M1(0xff);
		}
		EPD_W21_WriteCMD_M1(0x13);
		for(column=492;column<984;column++)
		 for(row=0;row<81;row++)
		{
		EPD_W21_WriteDATA_M1(~gImage_1304x984_bw[row+column*163]);
		}
		
		////////S1 part//////////656*492
		EPD_W21_WriteCMD_S1(0x10);
		for(column=492;column<984;column++)
		 for(row=81;row<163;row++)
		{
		EPD_W21_WriteDATA_S1(0xff);
		}
		EPD_W21_WriteCMD_S1(0x13);
		for(column=492;column<984;column++)
		 for(row=81;row<163;row++)
		{                                                                                                         
		EPD_W21_WriteDATA_S1(~gImage_1304x984_bw[row+column*163]);
		}
		
		////////M2 part//////////656*492
		EPD_W21_WriteCMD_M2(0x10);
		for(column=0;column<492;column++)
		 for(row=81;row<163;row++)
		{
		EPD_W21_WriteDATA_M2(0xff);
		}
		EPD_W21_WriteCMD_M2(0x13);
		for(column=0;column<492;column++)
		 for(row=81;row<163;row++)
		{
		EPD_W21_WriteDATA_M2(~gImage_1304x984_bw[row+column*163]);
		}
		////////S2 part//////////648*492
		EPD_W21_WriteCMD_S2(0x10);
		for(column=0;column<492;column++)
		 for(row=0;row<81;row++)
		{
		EPD_W21_WriteDATA_S2(0xff);
		}
		EPD_W21_WriteCMD_S2(0x13);
		for(column=0;column<492;column++)
		 for(row=0;row<81;row++)
		{
		EPD_W21_WriteDATA_S2(~gImage_1304x984_bw[row+column*163]);
		}

}
//picture white//
void pic_display_white(void)
{
	unsigned int column,row;
		////////M1 part//////////648*492
		EPD_W21_WriteCMD_M1(0x10);
		for(column=492;column<984;column++)
		 for(row=0;row<81;row++)
		{
		EPD_W21_WriteDATA_M1(0xff);
		}
		EPD_W21_WriteCMD_M1(0x13);
		for(column=492;column<984;column++)
		 for(row=0;row<81;row++)
		{
		EPD_W21_WriteDATA_M1(0xff);
		}
		
		////////S1 part//////////656*492
		EPD_W21_WriteCMD_S1(0x10);
		for(column=492;column<984;column++)
		 for(row=81;row<163;row++)
		{
		EPD_W21_WriteDATA_S1(0xff);
		}
		EPD_W21_WriteCMD_S1(0x13);
		for(column=492;column<984;column++)
		 for(row=81;row<163;row++)
		{                                                                                                         
		EPD_W21_WriteDATA_S1(0xff);
		}
		
		////////M2 part//////////656*492
		EPD_W21_WriteCMD_M2(0x10);
		for(column=0;column<492;column++)
		 for(row=81;row<163;row++)
		{
		EPD_W21_WriteDATA_M2(0xff);
		}
		EPD_W21_WriteCMD_M2(0x13);
		for(column=0;column<492;column++)
		 for(row=81;row<163;row++)
		{
		EPD_W21_WriteDATA_M2(0xff);
		}
		////////S2 part//////////648*492
		EPD_W21_WriteCMD_S2(0x10);
		for(column=0;column<492;column++)
		 for(row=0;row<81;row++)
		{
		EPD_W21_WriteDATA_S2(0xff);
		}
		EPD_W21_WriteCMD_S2(0x13);
		for(column=0;column<492;column++)
		 for(row=0;row<81;row++)
		{
		EPD_W21_WriteDATA_S2(0xff);
		}

}
void lcd_chkstatus_M1(void)
{
	unsigned char busy;
	do
		{
		EPD_W21_WriteCMD_M1(0x71);
		busy = EPD_W21_ReadDATA_M1;
		busy =!(busy & 0x01);
		}
	while(busy);
  driver_delay_xms(200);
}

void lcd_chkstatus_M2(void)
{
	unsigned char busy;
	do
		{
		EPD_W21_WriteCMD_M2(0x71);
		busy = EPD_W21_ReadDATA_M2;
		busy =!(busy & 0x01);
		}
	while(busy);
  driver_delay_xms(200);
}
void lcd_chkstatus_S1(void)
{
	unsigned char busy;
	do
		{
		EPD_W21_WriteCMD_S1(0x71);
		busy = EPD_W21_ReadDATA_S1;
		busy =!(busy & 0x01);
		}
	while(busy);
  driver_delay_xms(200);
}

void lcd_chkstatus_S2(void)
{
	unsigned char busy;
	do
		{
		EPD_W21_WriteCMD_S2(0x71);
		busy = EPD_W21_ReadDATA_S2;
		busy =!(busy & 0x01);
		}
	while(busy);
  driver_delay_xms(200);
}




