/********************  DKE EPD  ***********************************************
 *     NXF
 * ʵƽ̨EpaperDemoV5
 *     ֽʼ 
 * ʱ    2017.05.30
*******************************************************************************/
#include "epaper.h"   
#include "delay.h"  

char vcom=0x52;		
extern u8 Epaper_border;
const unsigned char LUT[]=
{						
0x80,	0xA5,	0x10,	0x0,	0x0,	0x0,	0x0,
0x10,	0xA5,	0x80,	0x0,	0x0,	0x0,	0x0,
0x80,	0xA5,	0x10,	0x0,	0x0,	0x0,	0x0,
0x10,	0xA5,	0x80,	0x0,	0x0,	0x0,	0x0,
0x0,	0x0,	0x0,	0x0,	0x0,	0x0,	0x0,
0x6,	0x8,	0x0,	0x0,	0x2,		
0xC,	0x0,	0xC,	0x0,	0x5,		
0x8,	0x6,	0x0,	0x0,	0x2,		
0x0,	0x0,	0x0,	0x0,	0x0,		
0x0,	0x0,	0x0,	0x0,	0x0,		
0x0,	0x0,	0x0,	0x0,	0x0,		
0x0,	0x0,	0x0,	0x0,	0x0,		
0x17,	0x41,	0x0,	0x32,			
0x15,	0x0B};				
		
/*
 * EpaperIO_Init
 *   ʼֽصIOӿ
 *   
 *   
 */	    
void EpaperIO_Init(void)
{
	GPIO_InitTypeDef  GPIO_InitStructure;
 	
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOD|RCC_APB2Periph_GPIOE, ENABLE);//ʹPDE˿ʱ

	//EPAPER_EN(BS),
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_11 ;								//˿, 
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP; 		 		
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;		 			
	GPIO_Init(GPIOE, &GPIO_InitStructure);	  				     	
	
	 //CS-->PD8   SCK-->PD9  SDO--->PD10 
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8|GPIO_Pin_9|GPIO_Pin_10;		//˿, 
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP; 		 			
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;		 		
	GPIO_Init(GPIOD, &GPIO_InitStructure);	  	
	
	
	
	 // D/C--->PE15	   RES-->PE14
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_14|GPIO_Pin_15;		//˿, 
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP; 		 			
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;		 		
	GPIO_Init(GPIOE, &GPIO_InitStructure);	  				     		
	
	// BUSY--->PE13
	GPIO_InitStructure.GPIO_Pin  = GPIO_Pin_13;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPD;	//
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
 	GPIO_Init(GPIOE, &GPIO_InitStructure);				//ʼGPIO

}


/*
 * SPI1_WriteByte
 *   SPIx дһֽ
 *   TxData:Ҫдֽ
 *   ֵ:ȡֽ
 */
void Epaper_Spi_WriteByte(u8 TxData)
{				   			 
	u8 TempData;
	u8 scnt;
	TempData=TxData;

  Epaper_SCK =0;  
	for(scnt=0;scnt<8;scnt++)
	{ 
		if(TempData&0x80)
		  Epaper_SDO=1 ;
		else
		  Epaper_SDO=0 ;
		Epaper_SCK =1; 
    delay_us(5) ; 
	  Epaper_SCK =0;  
		TempData=TempData<<1;
		delay_us(5) ; 
  }

}
/*
 * HalLcd_READBUSY
 *   ȴֽbusyźɸ߱ 
 *   
 *   
 */	
void Epaper_READBUSY(void)
{ 
  while(1)
  {	 //=1 BUSY
     if(Epaper_BUSY==0) break;
		 delay_us(5) ;
  }  
	 delay_us(100) ;
}

/*
 * Epaper_Write_Command
 *   д
 *   cmd
 *   
 */	
void Epaper_Write_Command(u8 cmd)
{
	 Epaper_CS =1;
	 Epaper_CS =0;
   Epaper_DC=0;  // D/C#   0:command  1:data

	 delay_us(5) ;
 Epaper_Spi_WriteByte(cmd);
	 delay_us(5) ;
 Epaper_CS =1;
}


/*
 * Epaper_Write_Command
 *   д
 *   cmd
 *   
 */	
void Epaper_Write_Data(u8 data)
{
	 Epaper_CS =1;
	 Epaper_CS =0;
 Epaper_DC=1;  // D/C#   0:command  1:data

 delay_us(5) ;
 Epaper_Spi_WriteByte(data);
 delay_us(5) ;
 Epaper_CS =1;
}


/*
 * Epaper_Update
 *   ֽʼ򣬸ֽ
 *   wave_data
 *   
 */	
void Epaper_Update(void)
{
    Epaper_Write_Command(0x21);
    Epaper_Write_Data(0x40);

    Epaper_Write_Command(0x22);
    Epaper_Write_Data(0xC7);    			
    Epaper_Write_Command(0x20);
    Epaper_READBUSY();
    delay_ms(100); 	
}

/*
 * Epaper_DeepSleep
 *   ֽ˯ģʽ
 *   wave_data
 *   
 */	
void Epaper_DeepSleep(void)
{
   Epaper_Write_Command(0x10);
   Epaper_Write_Data(0x01);   
   delay_ms(100); 	
   //Epaper_EN =0;///Epaper VCC Off
   delay_ms(100); 	
}
/*
 * Epaper_Init
 *   ֽʼ򣬸ֽ
 *   wave_data
 *   
 */	
void Epaper_Init(void)
{  
    //Epaper_EN=1; ///Epaper VCC On
    delay_ms(100); 
    Epaper_RESET=0;     
    delay_ms(10); 
    Epaper_RESET=1; //hard reset  
    delay_ms(10);  
    Epaper_READBUSY();
    Epaper_Write_Command(0x12); // soft reset
    Epaper_READBUSY();
	
    Epaper_Write_Command(0x74); //set analog block control       
     Epaper_Write_Data(0x54);
    Epaper_Write_Command(0x7E); //set digital block control          
     Epaper_Write_Data(0x3B);
	
    Epaper_Write_Command(0x01); //Driver output control      
     Epaper_Write_Data(0x97);
     Epaper_Write_Data(0x00);
     Epaper_Write_Data(0x00);
	
    Epaper_Write_Command(0x11); //data entry mode       
     Epaper_Write_Data(0x01);
		
    Epaper_Write_Command(0x44); //set Ram-X address start/end position   
     Epaper_Write_Data(0x00);
    Epaper_Write_Data(0x12);    //0x12-->(18+1)*8=152
	
    Epaper_Write_Command(0x45); //set Ram-Y address start/end position          
     Epaper_Write_Data(0x97);   //0x97-->(151+1)=152
    Epaper_Write_Data(0x00);
     Epaper_Write_Data(0x00);
    Epaper_Write_Data(0x00); 
    Epaper_Write_Command(0x3C); //set border 
     Epaper_Write_Data(0x01);	
}



/*
 * Epaper_LUT
 *   ز SSD1675
 *   wave_data
 *   
 */	
void Epaper_LUT(u8 * wave_data)
{        
  u8 count;
  Epaper_Write_Command(0x32);//write LUT by MCU
  for(count=0;count<70;count++) Epaper_Write_Data(*wave_data++); 
  Epaper_READBUSY();
 
}

void LUT_Written_by_MCU(void)
{
	
   Epaper_Write_Command(0x2C); //set vcom      
    Epaper_Write_Data( vcom);
		
    Epaper_Write_Command(0x03);//set gate voltage       
    Epaper_Write_Data(LUT[70]);
		
    Epaper_Write_Command(0x04); //set source voltage          
    Epaper_Write_Data(LUT[71]); //vsh1
    Epaper_Write_Data(LUT[72]); //vsh2
    Epaper_Write_Data(LUT[73]); //vsl
		
    Epaper_Write_Command(0x3A); // set frequency1-dummy line      
    Epaper_Write_Data(LUT[74]);
    Epaper_Write_Command(0x3B); // set frequency2-line width        
    Epaper_Write_Data(LUT[75]);
		
    Epaper_LUT((u8*)LUT);
	
}
	
/*
 * Epaper_Load_Image
 *   RAM ˢͼƬ
 *   datas
         num
         : mode 
 *   
 */	
void Epaper_Load_Image(u8 *datas,u32 num,u8 mode)
{
  u32 i; 
  u8 tempOriginal;      
  u32 tempcol=0;
  u32 templine=0;

  Epaper_Write_Command(0x4E);     
    Epaper_Write_Data(0x00);

	
	  Epaper_Write_Command(0x4F);       
		Epaper_Write_Data(0x97);
	  Epaper_Write_Data(0x00);
	
		Epaper_READBUSY();
	if(mode==MONO)
    Epaper_Write_Command(0x24);   //write RAM for black(0)/white (1)
  if(mode==RED)
		Epaper_Write_Command(0x26);   //write RAM for black(0)/white (1)
	
	for(i=0;i<num;i++)
   {          
     tempOriginal=*(datas+templine*MAX_COLUMN_BYTES+tempcol);
     templine++;
     if(templine>=MAX_LINE_BYTES)
     {
       tempcol++;
       templine=0;
     }     
     Epaper_Write_Data(tempOriginal);
   } 
	 Epaper_Update();

}


/*
 * Display_All_White
 *   ˢʾȫ
 *   
 *   
 */	
void Display_All_White(void)
{
  u32 i,j; 

    Epaper_Write_Command(0x4E);     
    Epaper_Write_Data(0x00);
	
	  Epaper_Write_Command(0x4F);       
		Epaper_Write_Data(0x97);
	  Epaper_Write_Data(0x00);

	
		Epaper_READBUSY();
    Epaper_Write_Command(0x24);   
		for(i=0;i<152;i++)
    {
	   for(j=0;j<19;j++)
	   {
		  Epaper_Write_Data(0xFF);
           }
    }
		Epaper_Update();
	 
}

/*
 * Display_All_Black
 *   ˢʾȫ
 *   
 *   
 */	
void Display_All_Black(void)
{
  u32 i,j; 

			Epaper_Write_Command(0x4E);     
    Epaper_Write_Data(0x00);
	
	  Epaper_Write_Command(0x4F);       
		Epaper_Write_Data(0x97);
	  Epaper_Write_Data(0x00);

	
		Epaper_READBUSY();
    Epaper_Write_Command(0x24);   
		for(i=0;i<152;i++)
   {
	   for(j=0;j<19;j++)
	   {
		  Epaper_Write_Data(0x00);
     }
   }
	 Epaper_Update();

}

  

