#include "sys.h"
#include "delay.h"
#include "epaper.h"  
#include "array.h" 

//Tips//
/*When the electronic paper is refreshed in full screen, the picture flicker is a normal phenomenon, and the main function is to clear the display afterimage in the previous picture.
  When the local refresh is performed, the screen does not flash.*/
/*When you need to transplant the driver, you only need to change the corresponding IO. The BUSY pin is the input mode and the others are the output mode. */
	
 int main(void)
 {	
		delay_init();	    //Delay function initialization
		 
		//Hardware setup
		EpaperIO_Init(); //IO port initialization
		Epaper_Init(); //Electronic paper hardware reset and coordinate setting
		LUT_Written_by_MCU();//Electronic paper power supply settings and loading LUT
		 
		//Loading image
		Display_All_Black();//full black                                                        
		Display_All_White();//full white
		Epaper_DeepSleep(); //Enter deep sleep,Sleep instruction is necessary, please do not delete!!!
 while(1)
	{
	  Epaper_Init(); //Electronic paper hardware reset and coordinate setting
	  LUT_Written_by_MCU();//Electronic paper power supply settings and loading LUT
			
		Epaper_Load_Image((u8*) gImage_1,ALLSCREEN_BYTES,MONO); //Picture 1
		Epaper_Load_Image((u8*) gImage_2,ALLSCREEN_BYTES,MONO); //Picture 2
    Epaper_DeepSleep(); //Enter deep sleep,Sleep instruction is necessary, please do not delete!!!
		while(1);
	}

 }




