#include "epaper.h"   
#include "delay.h"  

extern u8  DIS_EN_FLAG;


char vcom=0x26;		
extern u8 Epaper_border;
const unsigned char LUT[]=
 {
0x80,	0xA5,	0x10,	0x0,	0x0,	0x0,	0x0,
0x10,	0xA5,	0x80,	0x0,	0x0,	0x0,	0x0,
0x80,	0xA5,	0x10,	0x0,	0x0,	0x0,	0x0,
0x10,	0xA5,	0x80,	0x0,	0x0,	0x0,	0x0,
0x0,	0x0,	0x0,	0x0,	0x0,	0x0,	0x0,
0x6,	0x8,	0x0,	0x0,	0x2,		
0xC,	0x0,	0xC,	0x0,	0x5,		
0x8,	0x6,	0x0,	0x0,	0x2,		
0x0,	0x0,	0x0,	0x0,	0x0,		
0x0,	0x0,	0x0,	0x0,	0x0,		
0x0,	0x0,	0x0,	0x0,	0x0,		
0x0,	0x0,	0x0,	0x0,	0x0,		
0x17,	0x41,	0x0,	0x32,			
0x1,	0x8};					
			
		   
void EpaperIO_Init(void)
{
	GPIO_InitTypeDef  GPIO_InitStructure;
 	
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOD|RCC_APB2Periph_GPIOE, ENABLE);

	//EPAPER_EN(BS),
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_11 ;								//Port configuration, push-pull output
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP; 		 		
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;		 			
	GPIO_Init(GPIOE, &GPIO_InitStructure);	  				     	
	
	 //CS-->PD8   SCK-->PD9  SDO--->PD10 
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8|GPIO_Pin_9|GPIO_Pin_10;		//Port configuration, push-pull output
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP; 		 			
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;		 		
	GPIO_Init(GPIOD, &GPIO_InitStructure);	  	
	
	
	
	 // D/C--->PE15	   RES-->PE14
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_14|GPIO_Pin_15;		//Port configuration, push-pull output
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP; 		 			
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;		 		
	GPIO_Init(GPIOE, &GPIO_InitStructure);	  				     		
	
	// BUSY--->PE13
	GPIO_InitStructure.GPIO_Pin  = GPIO_Pin_13;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPD;	//Pull down input
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
 	GPIO_Init(GPIOE, &GPIO_InitStructure);				//Initialize GPIO

}



void Epaper_Spi_WriteByte(u8 TxData)
{				   			 
	u8 TempData;
	u8 scnt;
	TempData=TxData;

  Epaper_SCK =0;  
	for(scnt=0;scnt<8;scnt++)
	{ 
		if(TempData&0x80)
		  Epaper_SDO=1 ;
		else
		  Epaper_SDO=0 ;
		Epaper_SCK =1; 
    delay_us(5) ; 
	  Epaper_SCK =0;  
		TempData=TempData<<1;
		delay_us(5) ; 
  }

}

void Epaper_READBUSY(void)
{ 
  while(1)
  {	 //=1 BUSY
     if(Epaper_BUSY==0) break;
		 delay_us(5) ;
  }  
	 delay_us(100) ;
}


void Epaper_Write_Command(u8 cmd)
{
	Epaper_CS =1;
	Epaper_CS =0;
	Epaper_DC=0;  // D/C#   0:command  1:data

	delay_us(5) ;
	Epaper_Spi_WriteByte(cmd);
	 delay_us(5) ;
	Epaper_CS =1;
}



void Epaper_Write_Data(u8 data)
{
	Epaper_CS =1;
	Epaper_CS =0;
	Epaper_DC=1;  // D/C#   0:command  1:data

	delay_us(5) ;
	Epaper_Spi_WriteByte(data);
	delay_us(5) ;
	Epaper_CS =1;
}
	
void Epaper_Update(void)
{

    Epaper_Write_Command(0x22);//Display Update Control 
    Epaper_Write_Data(0xC7);    			
    Epaper_Write_Command(0x20);//Activate Display Update Sequence 
    Epaper_READBUSY();
    delay_ms(100); 	
}
	
void Epaper_DeepSleep(void)
{
   Epaper_Write_Command(0x10);
   Epaper_Write_Data(0x01);   
   delay_ms(100); 	
   //Epaper_EN =0;///Epaper VCC Off
   delay_ms(100); 	
}

void Epaper_Init(void)
{  
    delay_ms(100); 
    Epaper_RESET=0;     // Module reset    
    delay_ms(10);    //At least 10ms delay 
    Epaper_RESET=1;
    delay_ms(10);    //At least 10ms delay 
    Epaper_READBUSY();
    Epaper_Write_Command(0x12); // soft reset
    Epaper_READBUSY();
	
		Epaper_Write_Command(0x74); //set analog block control       
		Epaper_Write_Data(0x54);
		Epaper_Write_Command(0x7E); //set digital block control          
		Epaper_Write_Data(0x3B);

		Epaper_Write_Command(0x01); //Driver output control      
		Epaper_Write_Data(0x27);
		Epaper_Write_Data(0x01);
		Epaper_Write_Data(0x00);

		Epaper_Write_Command(0x11); //data entry mode       
		Epaper_Write_Data(0x01);

		Epaper_Write_Command(0x44); //set Ram-X address start/end position   
		Epaper_Write_Data(0x00);
		Epaper_Write_Data(0x0F);    //0x0F-->(15+1)*8=128

		Epaper_Write_Command(0x45); //set Ram-Y address start/end position          
		Epaper_Write_Data(0x27);   //0x0127-->(295+1)=296
		Epaper_Write_Data(0x01);
		Epaper_Write_Data(0x00);
		Epaper_Write_Data(0x00); 
		Epaper_Write_Command(0x3C); //set border 
		Epaper_Write_Data(0x01);	
}

void Epaper_LUT(u8 * wave_data)
{        
  u8 count;
  Epaper_Write_Command(0x32);//write LUT by MCU
  for(count=0;count<70;count++) Epaper_Write_Data(*wave_data++); 
  Epaper_READBUSY();
 
}

void LUT_Written_by_MCU(void)
{
	
    Epaper_Write_Command(0x2C); //set vcom      
    Epaper_Write_Data( vcom);
		
    Epaper_Write_Command(0x03);//set gate voltage       
    Epaper_Write_Data(LUT[70]);
		
    Epaper_Write_Command(0x04); //set source voltage          
    Epaper_Write_Data(LUT[71]); //vsh1
    Epaper_Write_Data(LUT[72]); //vsh2
    Epaper_Write_Data(LUT[73]); //vsl
		
    Epaper_Write_Command(0x3A); // set frequency1-dummy line      
    Epaper_Write_Data(LUT[74]);
    Epaper_Write_Command(0x3B); // set frequency2-line width        
    Epaper_Write_Data(LUT[75]);
		
    Epaper_LUT((u8*)LUT);
	
}
	
void Epaper_Load_Image(u8 *datas,u32 num,u8 mode)
{
  u32 i; 
  u8 tempOriginal;      
  u32 tempcol=0;
  u32 templine=0;

    Epaper_Write_Command(0x4E);     
    Epaper_Write_Data(0x00);

	
	  Epaper_Write_Command(0x4F);       
		Epaper_Write_Data(0x27);
	  Epaper_Write_Data(0x01);
	
		Epaper_READBUSY();
	if(mode==MONO)
    Epaper_Write_Command(0x24);   //write RAM for black(0)/white (1)
  if(mode==RED)
		Epaper_Write_Command(0x26);   //write RAM for black(0)/white (1)
	
	for(i=0;i<num;i++)
   {          
     tempOriginal=*(datas+templine*MAX_COLUMN_BYTES+tempcol);
     templine++;
     if(templine>=MAX_LINE_BYTES)
     {
       tempcol++;
       templine=0;
     }     
     Epaper_Write_Data(tempOriginal);
   } 
	
	  Epaper_Update();
}
	
void Display_All_White(void)
{
  u32 i,j; 

    Epaper_Write_Command(0x4E);     
    Epaper_Write_Data(0x00);

	
	  Epaper_Write_Command(0x4F);       
		Epaper_Write_Data(0x27);
	  Epaper_Write_Data(0x01);

	
		Epaper_READBUSY();
    Epaper_Write_Command(0x24);   
		for(i=0;i<296;i++)
    {
	   for(j=0;j<16;j++)
	   {
		  Epaper_Write_Data(0xFF);
           }
    }
		
		 Epaper_Update();
	 
}

void Display_All_Black(void)
{
  u32 i,j; 

    Epaper_Write_Command(0x4E);     
    Epaper_Write_Data(0x00);

	
	  Epaper_Write_Command(0x4F);       
		Epaper_Write_Data(0x27);
	  Epaper_Write_Data(0x01);
	
		Epaper_READBUSY();
    Epaper_Write_Command(0x24);   
		for(i=0;i<296;i++)
   {
	   for(j=0;j<16;j++)
	   {
		  Epaper_Write_Data(0x00);
     }
   }
	 
	  Epaper_Update();

}


void Display(void)
{
	u8 dis_num;
	u8 DIS_EN_FLAG=0;
	//dis_num=Read_dis_key_value();
	if(DIS_EN_FLAG==1)
	{
		DIS_EN_FLAG=0;
		switch(dis_num)
		{
	

		   case 0: 
		    Epaper_Init();
			 LUT_Written_by_MCU();
			 Display_All_White();
			 Epaper_Update();
			 Epaper_DeepSleep();
	     break;
		   case 1: 
		   Epaper_Init();
			 LUT_Written_by_MCU();
			 //Epaper_Load_Image((u8*)ESL,ALLSCREEN_BYTES,MONO);
			 Epaper_Update();
			 Epaper_DeepSleep();
		   
       case 2: 
		   Epaper_Init();
			 LUT_Written_by_MCU();
			 Display_All_Black ();
			 Epaper_Update();
			 Epaper_DeepSleep();
		   break;			

	
	     default:break;
		}
		
	}
  
}
