#include "stm32f10x.h"
#include "board.h"
#include "driver.h"
#include "data.h"
#include "epd.h"
#include "power.h"
#include "picture.h"

u8 wf_mode = EPD_MODE_INIT;				//EPD refresh mode
int main(void)
{	
			u32 i;
			
			for(i=0;i<10000;i++);
			SYS_Init();										//system initialization
			IO_Init();										//IO port initialization
			
			GPIO_USART_Init();					 //Serial port initialization
			SPIx_Init();								//SPI initialization
			SYS_WAKEUP_H;
			Delay100ms(10);
			
			tps_init(); //TPS65185 initialization
			tps_sleep_to_standby(); //VCOM voltage setting
			AVT_CONFIG_check();			//Check whether the configuration command of the AVT is normal.
	
	  	Delay100ms(5);
	    avt_waveform_update();//Load waveform file
	
			avt_init();//Double flash
			epd_draw_gray(0xff);//Full gray
			Delay100ms(20);



		#if 1    //16-level grayscale demo
			Delay100ms(20);

			wf_mode = EPD_MODE_GC16;
			epd_draw_gray_level_horizontal(16);
			Delay100ms(20);

			epd_draw_gray_level_vertical(16);
			Delay100ms(20);

			epd_draw_gray_level_horizontal(8);
			Delay100ms(20);

			epd_draw_gray_level_vertical(8);
			Delay100ms(20);

			epd_draw_gray(0xff);
		#endif	
		
		 //Mobile display LOGO
      wf_mode = EPD_MODE_DU; 
			avt_run_sys();   //Partially refresh the picture
			avt_lut_demo(0); //LOGO display=
			avt_lut_demo(255);//LOGO disappears
			avt_slp();		
      Delay100ms(2);//2
      //Full gray               
			wf_mode = EPD_MODE_GC16;
			epd_draw_gray(0xff);  //Full gray
			Delay100ms(1);	//1
			

		while(1)
			{	
						////////////////Bureau brush refresh display/////////////////
			wf_mode = EPD_MODE_GC16;
			epd_draw_pic_part_from_rom((u8*)gImage_01, EPD_DATA_2BPP, 0, 0, 800, 133); //Picture 1.1, resolution 800*133
			Delay100ms(10);//10			
  		epd_draw_pic_part_from_rom((u8*)gImage_02, EPD_DATA_2BPP, 0, 133, 800, 105);//Picture 1.2, resolution 800*105
			Delay100ms(10);//10
			epd_draw_pic_part_from_rom((u8*)gImage_03, EPD_DATA_2BPP, 0, 238, 800, 175);//Picture 1.3, resolution 800*175
			Delay100ms(10);//10
			epd_draw_pic_part_from_rom((u8*)gImage_04, EPD_DATA_2BPP, 0, 413, 800, 187);//Picture 1.4, resolution 800*187
			Delay100ms(10);//10
			//Refresh screen             
			wf_mode = EPD_MODE_GC16;
			epd_draw_gray(0xff);  //Full gray
			epd_draw_gray(0xff); //Full gray
	          ////////////////Display pictures in full screen/////////////////
			
			epd_draw_pic_part_from_rom((u8*)gImage_1, EPD_DATA_2BPP, 0, 0, 800, 600);//Picture 1resolution 800*600
			Delay100ms(30);//ʱ3s
			//Refresh screen     
      wf_mode = EPD_MODE_GC16;				
			epd_draw_gray(0xff); //Full gray
			epd_draw_gray(0xff); //Full gray
			epd_draw_pic_part_from_rom((u8*)gImage_2, EPD_DATA_2BPP, 0, 0, 800, 600);//Picture 2resolution 800*600
			Delay100ms(30);
			//Refresh screen     
      wf_mode = EPD_MODE_GC16;			
			epd_draw_gray(0xff);  //Full gray
			epd_draw_gray(0xff);  //Full gray
			
						//Refresh screen     
      wf_mode = EPD_MODE_GC16;				
			epd_draw_gray(0xff); //Full gray
			epd_draw_gray(0xff); //Full gray
			epd_draw_pic_part_from_rom((u8*)gImage_2, EPD_DATA_2BPP, 0, 0, 800, 600);//Picture 2resolution 800*600
			Delay100ms(30);
			while(1);
	   }


}





























